<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */
 
  /*===================================================
    ShowFormMailingList()
  ===================================================*/

  function ShowFormMailingList() {

    // vars global configuration
    global $theme_path;

    // vars template
    global $error_msg, $email;

    DisplayTemplate($theme_path . "mailing_list_form.html", "\$error_msg,\$email");
  }


  /*===================================================
    ProcessFormMailingList()
  ===================================================*/
  
  function ProcessFormMailingList() {

    // vars global configuration
    global $theme_path, $spam_proof, $site_url, $email_address;

    // vars url & form
    global $act, $email;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $confirm_url;

    if (empty($email))
      $error_msg = $msg["10251"];
    elseif (!IsEmailAddress($email))
      $error_msg = $msg["10252"];

    if (empty($error_msg)) {
      $ml_obj = new clsMailingList;
      $ml_obj->table_name = "idx_mailing_list";

      if ($act == "subscribe") {
        $subscribe_result = $ml_obj->Subscribe($email, $spam_proof);

        if ($subscribe_result == 0) {

          // success
          $body = EvalTemplate($theme_path . "mail/mailing_list_sub.mail", "\$email");
          $from = $email_address;
          @mail($email, $msg["10263"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");

          DisplayTemplate($theme_path . "mailing_list_sub_ok.html", "\$email");
        }
        elseif ($subscribe_result == 1) {

          // pending
          $code        = $ml_obj->code;
          $confirm_url = $site_url . "/mailing_list.php?p=confirm&e=$email&c=$code";
          $body        = EvalTemplate($theme_path . "mail/mailing_list_sub_confirm.mail", "\$email,\$confirm_url");
          $from        = $email_address;
          @mail($email, $msg["10261"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");

          DisplayTemplate($theme_path . "mailing_list_sub_confirm.html", "\$email");
        }
        elseif ($subscribe_result == 2) {

          // already exist
          $error_msg = $msg["10253"];
          ShowFormMailingList();
        }
      }
      elseif ($act == "unsubscribe") {
        $unsubscribe_result = $ml_obj->Unsubscribe($email);

        if ($unsubscribe_result == 0) {

          // success
          DisplayTemplate($theme_path . "mailing_list_unsub_ok.html", "\$email");
        }
        elseif ($unsubscribe_result == 1) {

          // already exist
          $error_msg = $msg["10254"];
          ShowFormMailingList();
        }
      }
    }
    else
      ShowFormMailingList();
  }


  /*===================================================
    ConfirmMailingList()
  ===================================================*/
  
  function ConfirmMailingList() {

    // vars global configuration
    global $theme_path, $spam_proof, $site_url;

    // vars url & form
    global $c, $e;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $email;

    $ml_obj = new clsMailingList;
    $ml_obj->table_name = "idx_mailing_list";
    $confirm_result     = $ml_obj->Confirm($e, $c);

    if ($confirm_result == 0) {
      // success
      $email = $e;
      DisplayTemplate($theme_path . "mailing_list_sub_ok.html", "\$email");
    }
    else {
      // fail
      DisplayTemplate($theme_path . "mailing_list_sub_confirm_error.html");
    }
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  if ($p == 'confirm') {
    ConfirmMailingList();
  }
  elseif (empty($pflag)) {
    ShowFormMailingList();
  }
  elseif ($pflag == 'ml') {
    ProcessFormMailingList();
  }

  RunPostFilter(__FILE__);

?>